﻿<?php
	$dir = $_SERVER['DOCUMENT_ROOT']."/".substr(substr($_SERVER['REQUEST_URI'], 1), 0, strpos(substr($_SERVER['REQUEST_URI'], 1), '/'))."/phone_gap";
	require_once($dir."/classes/Vendedor.class.php");
	require_once($dir."/classes/Dados.class.php");
	
	abstract class TipoMeta {
		//GERAL
		const PositivCli = 0;
		const Efetividade = 1;
		const CliNovos = 2;
		const Visitas = 3;
		const ValorTotal = 12;
		const QtdeTotal = 13;
		const SellOutTotal = 26;
		const TrocasTotal = 27;
		const CliSobreBase = 33;
		const QtdePedidos = 34;
		const MixProdutos = 52;
		const PositivGeral = 60;
		const QtdeMaster = 68;
		const PesoBruto = 69;
		const PesoLiquido = 70;

		//GRUPO
		const GrupoValor = 4;
		const GrupoQtde = 5;
		const GrupoPositiv = 14;
		const GrupoSellOut = 21;
		const GrupoTrocas = 28;
		const GrupoCliNovos = 35;
		const GrupoCliSobreBase = 46;
		const GrupoPositivGeral = 61;
		const GrupoQtdeMaster = 71;
		const GrupoPesoBruto = 72;
		const GrupoPesoLiquido = 73;

		//SUBGRUPO
		const SubgrupoValor = 6;
		const SubgrupoQtde = 7;
		const SubgrupoPositiv = 15;
		const SubgrupoSellOut = 22;
		const SubgrupoTrocas = 29;
		const SubgrupoCliNovos = 36;
		const SubgrupoCliSobreBase = 47;
		const SubgrupoPositivGeral = 62;
		const SubgrupoQtdeMaster = 74;
		const SubgrupoPesoBruto = 75;
		const SubgrupoPesoLiquido = 76;

		//FAMÍLIA
		const FamiliaValor = 8;
		const FamiliaQtde = 9;
		const FamiliaPositiv = 16;
		const FamiliaSellOut = 23;
		const FamiliaTrocas = 30;
		const FamiliaCliNovos = 37;
		const FamiliaCliSobreBase = 48;
		const FamiliaPositivGeral = 63;
		const FamiliaQtdeMaster = 77;
		const FamiliaPesoBruto = 78;
		const FamiliaPesoLiquido = 79;

		//PRODUTO
		const ProdutoValor = 10;
		const ProdutoQtde = 11;
		const ProdutoPositiv = 17;
		const ProdutoSellOut = 25;
		const ProdutoTrocas = 32;
		const ProdutoCliNovos = 38;
		const ProdutoCliSobreBase = 49;
		const ProdutoPositivGeral = 64;
		const ProdutoQtdeMaster = 80;
		const ProdutoPesoBruto = 81;
		const ProdutoPesoLiquido = 82;

		//MARCA
		const MarcaValor = 18;
		const MarcaQtde = 19;
		const MarcaPositiv = 20;
		const MarcaSellOut = 24;
		const MarcaTrocas = 31;
		const MarcaCliNovos = 39;
		const MarcaCliSobreBase = 50;
		const MarcaPositivGeral = 65;
		const MarcaQtdeMaster = 83;
		const MarcaPesoBruto = 84;
		const MarcaPesoLiquido = 85;

		//UNIFICADA
		const UnificadaValor = 40;
		const UnificadaQtde = 41;
		const UnificadaPositiv = 42;
		const UnificadaSellOut = 43;
		const UnificadaTrocas = 44;
		const UnificadaCliNovos = 45;
		const UnificadaCliSobreBase = 51;
		const UnificadaPositivGeral = 66;
		const UnificadaQtdeMaster = 86;
		const UnificadaPesoBruto = 87;
		const UnificadaPesoLiquido = 88;

		//FORNECEDOR
		const FornecedorValor = 53;
		const FornecedorQtde = 54;
		const FornecedorPositiv = 55;
		const FornecedorSellOut = 56;
		const FornecedorTrocas = 57;
		const FornecedorCliNovos = 58;
		const FornecedorCliSobreBase = 59;
		const FornecedorPositivGeral = 67;
		const FornecedorQtdeMaster = 89;
		const FornecedorPesoBruto = 90;
		const FornecedorPesoLiquido = 91;
		
		//LISTA DE METAS POR TIPO
		public static function Positivacao(){
			return array(TipoMeta::PositivCli, TipoMeta::GrupoPositiv, TipoMeta::SubgrupoPositiv, TipoMeta::FamiliaPositiv, 
						 TipoMeta::ProdutoPositiv, TipoMeta::MarcaPositiv, TipoMeta::UnificadaPositiv, TipoMeta::FornecedorPositiv);
		}
		
		public static function PositivacaoGeral(){
			return array(TipoMeta::PositivGeral, TipoMeta::GrupoPositivGeral, TipoMeta::SubgrupoPositivGeral, TipoMeta::FamiliaPositivGeral,
						 TipoMeta::ProdutoPositivGeral, TipoMeta::MarcaPositivGeral, TipoMeta::UnificadaPositivGeral, TipoMeta::FornecedorPositivGeral);
		}
		
		public static function Valores(){
			return array(TipoMeta::GrupoValor, TipoMeta::SubgrupoValor, TipoMeta::FamiliaValor, TipoMeta::ProdutoValor,
						 TipoMeta::ValorTotal, TipoMeta::MarcaValor, TipoMeta::UnificadaValor, TipoMeta::FornecedorValor);
		}
		
		public static function Qtdes(){
			return array(TipoMeta::GrupoQtde, TipoMeta::SubgrupoQtde, TipoMeta::FamiliaQtde, TipoMeta::ProdutoQtde,
						 TipoMeta::QtdeTotal, TipoMeta::MarcaQtde, TipoMeta::UnificadaQtde, TipoMeta::FornecedorQtde);
		}
		
		public static function SellOuts(){
			return array(TipoMeta::GrupoSellOut, TipoMeta::SubgrupoSellOut, TipoMeta::FamiliaSellOut, TipoMeta::MarcaSellOut, 
						 TipoMeta::ProdutoSellOut, TipoMeta::SellOutTotal, TipoMeta::UnificadaSellOut, TipoMeta::FornecedorSellOut);
		}
		
		public static function Trocas(){
			return array(TipoMeta::GrupoTrocas, TipoMeta::SubgrupoTrocas, TipoMeta::FamiliaTrocas, TipoMeta::MarcaTrocas, 
						 TipoMeta::ProdutoTrocas, TipoMeta::TrocasTotal, TipoMeta::UnificadaTrocas, TipoMeta::FornecedorTrocas);
		}
		
		public static function ClientesNovos(){
			return array(TipoMeta::GrupoCliNovos, TipoMeta::SubgrupoCliNovos, TipoMeta::FamiliaCliNovos, TipoMeta::MarcaCliNovos,
						 TipoMeta::ProdutoCliNovos, TipoMeta::CliNovos, TipoMeta::UnificadaCliNovos, TipoMeta::FornecedorCliNovos);
		}

		public static function ClientesSobreBase(){
			return array(TipoMeta::CliSobreBase, TipoMeta::GrupoCliSobreBase, TipoMeta::SubgrupoCliSobreBase, TipoMeta::FamiliaCliSobreBase,
						 TipoMeta::ProdutoCliSobreBase, TipoMeta::MarcaCliSobreBase, TipoMeta::UnificadaCliSobreBase, TipoMeta::FornecedorCliSobreBase);
		}

		public static function QtdesMaster(){
			return array(TipoMeta::QtdeMaster, TipoMeta::GrupoQtdeMaster, TipoMeta::SubgrupoQtdeMaster, TipoMeta::FamiliaQtdeMaster, 
						 TipoMeta::ProdutoQtdeMaster, TipoMeta::MarcaQtdeMaster, TipoMeta::UnificadaQtdeMaster, TipoMeta::FornecedorQtdeMaster);
		}
		
		public static function PesosBrutos(){
			return array(TipoMeta::PesoBruto, TipoMeta::GrupoPesoBruto, TipoMeta::SubgrupoPesoBruto, TipoMeta::FamiliaPesoBruto, 
						 TipoMeta::ProdutoPesoBruto, TipoMeta::MarcaPesoBruto, TipoMeta::UnificadaPesoBruto, TipoMeta::FornecedorPesoBruto);
		}
		
		public static function PesosLiquidos(){
			return array(TipoMeta::PesoLiquido, TipoMeta::GrupoPesoLiquido, TipoMeta::SubgrupoPesoLiquido, TipoMeta::FamiliaPesoLiquido, 
						 TipoMeta::ProdutoPesoLiquido, TipoMeta::MarcaPesoLiquido, TipoMeta::UnificadaPesoLiquido, TipoMeta::FornecedorPesoLiquido);
		}

		//LISTA DE METAS POR ORIGEM
		public static function Geral(){
			return array(TipoMeta::PositivCli, TipoMeta::Efetividade, TipoMeta::CliNovos, TipoMeta::Visitas, TipoMeta::ValorTotal, TipoMeta::QtdeTotal, TipoMeta::SellOutTotal, TipoMeta::TrocasTotal, 
						 TipoMeta::CliSobreBase, TipoMeta::QtdePedidos, TipoMeta::MixProdutos, TipoMeta::PositivGeral, TipoMeta::QtdeMaster, TipoMeta::PesoBruto, TipoMeta::PesoLiquido);
		}
		
		public static function Grupos(){
			return array(TipoMeta::GrupoValor, TipoMeta::GrupoQtde, TipoMeta::GrupoPositiv, TipoMeta::GrupoSellOut, TipoMeta::GrupoTrocas, TipoMeta::GrupoCliNovos, 
						 TipoMeta::GrupoCliSobreBase, TipoMeta::GrupoPositivGeral, TipoMeta::GrupoQtdeMaster, TipoMeta::GrupoPesoBruto, TipoMeta::GrupoPesoLiquido);
		}

		public static function Subgrupos(){
			return array(TipoMeta::SubgrupoValor, TipoMeta::SubgrupoQtde, TipoMeta::SubgrupoPositiv, TipoMeta::SubgrupoSellOut, TipoMeta::SubgrupoTrocas, TipoMeta::SubgrupoCliNovos,
						 TipoMeta::SubgrupoCliSobreBase, TipoMeta::SubgrupoPositivGeral, TipoMeta::SubgrupoQtdeMaster, TipoMeta::SubgrupoPesoBruto, TipoMeta::SubgrupoPesoLiquido);
		}
		
		public static function Familias(){
			return array(TipoMeta::FamiliaValor, TipoMeta::FamiliaQtde, TipoMeta::FamiliaPositiv, TipoMeta::FamiliaSellOut, TipoMeta::FamiliaTrocas, TipoMeta::FamiliaCliNovos,
						 TipoMeta::FamiliaCliSobreBase, TipoMeta::FamiliaPositivGeral, TipoMeta::FamiliaQtdeMaster, TipoMeta::FamiliaPesoBruto, TipoMeta::FamiliaPesoLiquido);
		}

		public static function Marcas(){
			return array(TipoMeta::MarcaValor, TipoMeta::MarcaQtde, TipoMeta::MarcaPositiv, TipoMeta::MarcaSellOut, TipoMeta::MarcaTrocas, TipoMeta::MarcaCliNovos, 
						 TipoMeta::MarcaCliSobreBase, TipoMeta::MarcaPositivGeral, TipoMeta::MarcaQtdeMaster, TipoMeta::MarcaPesoBruto, TipoMeta::MarcaPesoLiquido);
		}
		
		public static function Produtos(){
			return array(TipoMeta::ProdutoValor, TipoMeta::ProdutoQtde, TipoMeta::ProdutoPositiv, TipoMeta::ProdutoSellOut, TipoMeta::ProdutoTrocas, TipoMeta::ProdutoCliNovos,
						 TipoMeta::ProdutoCliSobreBase, TipoMeta::ProdutoPositivGeral, TipoMeta::ProdutoQtdeMaster, TipoMeta::ProdutoPesoBruto, TipoMeta::ProdutoPesoLiquido);
		}
		
		public static function Unificadas(){
			return array(TipoMeta::UnificadaValor, TipoMeta::UnificadaQtde, TipoMeta::UnificadaPositiv, TipoMeta::UnificadaSellOut, TipoMeta::UnificadaTrocas, TipoMeta::UnificadaCliNovos,
						 TipoMeta::UnificadaCliSobreBase, TipoMeta::UnificadaPositivGeral, TipoMeta::UnificadaQtdeMaster, TipoMeta::UnificadaPesoBruto, TipoMeta::UnificadaPesoLiquido);
		}
		
		public static function Fornecedores(){
			return array(TipoMeta::FornecedorValor, TipoMeta::FornecedorQtde, TipoMeta::FornecedorPositiv, TipoMeta::FornecedorSellOut, TipoMeta::FornecedorTrocas, TipoMeta::FornecedorCliNovos,
						 TipoMeta::FornecedorCliSobreBase, TipoMeta::FornecedorPositivGeral, TipoMeta::FornecedorQtdeMaster, TipoMeta::FornecedorPesoBruto, TipoMeta::FornecedorPesoLiquido);
		}

	}
	
	class Meta {
		
		private $vendedor;
		private $tipoMeta;
		private $descricao;
		private $meta;
		private $alcancado;
		private $saldo;
		private $MHD;
		private $tendencia;
		private $tendenciaSemFalta;
		private $NHD;
		private $diasUteis;
		private $diasTrab;
		private $faltas;
		private $diasFaltantes;
		private $tipo;
		private $metapor;
		private $codReferencia;
		private $codSubgrupo;
		private $mes;
		private $ano;
		private $codPeriodo;
		private $baseMeta;
		private $baseAlcancado;
 
		public function __construct() {
			$this->setVendedor(new Vendedor());
			$this->setTipoMeta(-1);
			$this->setDescricao("");
			$this->setMeta(0);
			$this->setAlcancado(0);
			$this->setSaldo(0);
			$this->setMHD(0);
			$this->setNHD(0);
			$this->setDiasUteis(0);
			$this->setDiasTrab(0);
			$this->setDiasFaltantes(0);
			$this->setTipo("");
			$this->setMetaPor("");
			$this->setCodReferencia("");
			$this->setCodSubgrupo("");
			$this->setMes("");
			$this->setAno("");
			$this->setCodPeriodo(0);
			$this->setBaseMeta(0);
			$this->setBaseAlcancado(0);
		}
		
		public function getMetasSelecionadas() {			
			$tipos = [];
			
			switch ($this->getTipo()) {				
				case '': //Todos
					switch ($this->getMetaPor()) {
						case 1: $tipos = TipoMeta::ClientesNovos(); break;
						case 2: $tipos = TipoMeta::ClientesSobreBase(); break;
						case 3: $tipos = TipoMeta::Efetividade; break;
						case 4: $tipos = TipoMeta::Positivacao(); break;
						case 5: $tipos = TipoMeta::Qtdes(); break;
						case 6: $tipos = TipoMeta::QtdePedidos; break;
						case 7: $tipos = TipoMeta::SellOuts(); break;
						case 8: $tipos = TipoMeta::Trocas(); break;
						case 9: $tipos = TipoMeta::Valores(); break;
						case 10: $tipos = TipoMeta::Visitas; break;
						case 11: $tipos = TipoMeta::MixProdutos; break;
						case 12: $tipos = TipoMeta::PositivacaoGeral(); break;       
						case 13: $tipos = TipoMeta::QtdesMaster(); break;
						case 14: $tipos = TipoMeta::PesosBrutos(); break;
						case 15: $tipos = TipoMeta::PesosLiquidos(); break;
					}
					break;
					
				case 'E': //Geral
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Geral(); break;
						case 1: $tipos = array(TipoMeta::CliNovos); break;
						case 2: $tipos = array(TipoMeta::CliSobreBase); break;
						case 3: $tipos = array(TipoMeta::Efetividade); break;
						case 4: $tipos = array(TipoMeta::PositivCli); break;
						case 5: $tipos = array(TipoMeta::QtdeTotal); break;
						case 6: $tipos = array(TipoMeta::QtdePedidos); break;
						case 7: $tipos = array(TipoMeta::SellOutTotal); break;
						case 8: $tipos = array(TipoMeta::TrocasTotal); break;
						case 9: $tipos = array(TipoMeta::ValorTotal); break;
						case 10: $tipos = array(TipoMeta::Visitas); break;
						case 11: $tipos = array(TipoMeta::MixProdutos); break;
						case 12: $tipos = array(TipoMeta::PositivGeral); break;       
						case 13: $tipos = array(TipoMeta::QtdeMaster); break;
						case 14: $tipos = array(TipoMeta::PesoBruto); break;
						case 15: $tipos = array(TipoMeta::PesoLiquido); break;
					}
					break;
				
				case 'F': //Família
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Familias(); break;
						case 1: $tipos = array(TipoMeta::FamiliaCliNovos); break;
						case 2: $tipos = array(TipoMeta::FamiliaCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::FamiliaPositiv); break;
						case 5: $tipos = array(TipoMeta::FamiliaQtde); break;
						case 7: $tipos = array(TipoMeta::FamiliaSellOut); break;
						case 8: $tipos = array(TipoMeta::FamiliaTrocas); break;
						case 9: $tipos = array(TipoMeta::FamiliaValor); break;
						case 12: $tipos = array(TipoMeta::FamiliaPositivGeral); break;        
						case 13: $tipos = array(TipoMeta::FamiliaQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::FamiliaPesoBruto); break;
						case 15: $tipos = array(TipoMeta::FamiliaPesoLiquido); break;
					}
					break;
				
				case 'M': //Marca
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Marcas(); break;
						case 1: $tipos = array(TipoMeta::MarcaCliNovos); break;
						case 2: $tipos = array(TipoMeta::MarcaCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::MarcaPositiv); break;
						case 5: $tipos = array(TipoMeta::MarcaQtde); break;
						case 7: $tipos = array(TipoMeta::MarcaSellOut); break;
						case 8: $tipos = array(TipoMeta::MarcaTrocas); break;
						case 9: $tipos = array(TipoMeta::MarcaValor); break;
						case 12: $tipos = array(TipoMeta::MarcaPositivGeral); break;        
						case 13: $tipos = array(TipoMeta::MarcaQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::MarcaPesoBruto); break;
						case 15: $tipos = array(TipoMeta::MarcaPesoLiquido); break;
					
					}
					break;
					
				case 'G': //Grupo
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Grupos(); break;
						case 1: $tipos = array(TipoMeta::GrupoCliNovos); break;
						case 2: $tipos = array(TipoMeta::GrupoCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::GrupoPositiv); break;
						case 5: $tipos = array(TipoMeta::GrupoQtde); break;
						case 7: $tipos = array(TipoMeta::GrupoSellOut); break;
						case 8: $tipos = array(TipoMeta::GrupoTrocas); break;
						case 9: $tipos = array(TipoMeta::GrupoValor); break;
						case 12: $tipos = array(TipoMeta::GrupoPositivGeral); break;        
						case 13: $tipos = array(TipoMeta::GrupoQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::GrupoPesoBruto); break;
						case 15: $tipos = array(TipoMeta::GrupoPesoLiquido); break;
					}
					break;
				
				case 'S': //Subgrupo
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Subgrupos(); break;
						case 1: $tipos = array(TipoMeta::SubGrupoCliNovos); break;
						case 2: $tipos = array(TipoMeta::SubGrupoCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::SubGrupoPositiv); break;
						case 5: $tipos = array(TipoMeta::SubGrupoQtde); break;
						case 7: $tipos = array(TipoMeta::SubGrupoSellOut); break;
						case 8: $tipos = array(TipoMeta::SubGrupoTrocas); break;
						case 9: $tipos = array(TipoMeta::SubGrupoValor); break;
						case 12: $tipos = array(TipoMeta::SubgrupoPositivGeral); break;         
						case 13: $tipos = array(TipoMeta::SubgrupoQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::SubgrupoPesoBruto); break;
						case 15: $tipos = array(TipoMeta::SubgrupoPesoLiquido); break;					
					}
					break;
				
				case 'P': //Produto
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Produtos(); break;
						case 1: $tipos = array(TipoMeta::ProdutoCliNovos); break;
						case 2: $tipos = array(TipoMeta::ProdutoCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::ProdutoPositiv); break;
						case 5: $tipos = array(TipoMeta::ProdutoQtde); break;
						case 7: $tipos = array(TipoMeta::ProdutoSellOut); break;
						case 8: $tipos = array(TipoMeta::ProdutoTrocas); break;
						case 9: $tipos = array(TipoMeta::ProdutoValor); break;
						case 12: $tipos = array(TipoMeta::ProdutoPositivGeral); break;         
						case 13: $tipos = array(TipoMeta::ProdutoQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::ProdutoPesoBruto); break;
						case 15: $tipos = array(TipoMeta::ProdutoPesoLiquido); break;					
					}
					break;
				
				case 'U': //Unificada
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Unificadas(); break;
						case 1: $tipos = array(TipoMeta::UnificadaCliNovos); break;
						case 2: $tipos = array(TipoMeta::UnificadaCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::UnificadaPositiv); break;
						case 5: $tipos = array(TipoMeta::UnificadaQtde); break;
						case 7: $tipos = array(TipoMeta::UnificadaSellOut); break;
						case 8: $tipos = array(TipoMeta::UnificadaTrocas); break;
						case 9: $tipos = array(TipoMeta::UnificadaValor); break;
						case 12: $tipos = array(TipoMeta::UnificadaPositivGeral); break;       
						case 13: $tipos = array(TipoMeta::UnificadaQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::UnificadaPesoBruto); break;
						case 15: $tipos = array(TipoMeta::UnificadaPesoLiquido); break;
					}
					break;
				
				case 'F': //Fornecedor
					switch ($this->getMetaPor()) {
						case 0: $tipos = TipoMeta::Fornecedores(); break;
						case 1: $tipos = array(TipoMeta::FornecedorCliNovos); break;
						case 2: $tipos = array(TipoMeta::FornecedorCliSobreBase); break;
						case 4: $tipos = array(TipoMeta::FornecedorPositiv); break;
						case 5: $tipos = array(TipoMeta::FornecedorQtde); break;
						case 7: $tipos = array(TipoMeta::FornecedorSellOut); break;
						case 8: $tipos = array(TipoMeta::FornecedorTrocas); break;
						case 9: $tipos = array(TipoMeta::FornecedorValor); break;
						case 12: $tipos = array(TipoMeta::FornecedorPositivGeral); break;        
						case 13: $tipos = array(TipoMeta::FornecedorQtdeMaster); break;
						case 14: $tipos = array(TipoMeta::FornecedorPesoBruto); break;
						case 15: $tipos = array(TipoMeta::FornecedorPesoLiquido); break;
					}
					break;
			}
			
			
			return $tipos;
		}
		
		public function getVendedor(){
			return $this->vendedor;
		}

		public function setVendedor($vendedor){
			$this->vendedor = $vendedor;
		}
		
		public function getTipoMeta(){
			return $this->tipoMeta;
		}

		public function setTipoMeta($tipoMeta){
			$this->tipoMeta = $tipoMeta;
		}

		public function getDescricao(){
			return $this->descricao;
		}

		public function setDescricao($descricao){
			$this->descricao = $descricao;
		}

		public function getMeta(){
			return $this->meta;
		}

		public function setMeta($meta){
			$dados = new Dados();
			$this->meta = $dados->StrToFloat($meta);
		}

		public function getAlcancado(){
			return $this->alcancado;
		}

		public function setAlcancado($alcancado){
			$dados = new Dados();
			$this->alcancado = $dados->StrToFloat($alcancado);
		}

		public function setSaldo($saldo){
			$dados = new Dados();
			$this->saldo = $dados->StrToFloat($saldo);;
		}
		
		public function getSaldo(){
			return $this->saldo;
		}

		public function setMHD($MHD){
			$dados = new Dados();
			$this->MHD = $dados->StrToFloat($MHD);
		}
		
		public function getMHD(){
			return $this->MHD;
		}
		
		public function setTendencia($tendencia){
			$dados = new Dados();
			$this->tendencia = $dados->StrToFloat($tendencia);
		}

		public function getTendencia(){
			return $this->tendencia;
		}

		public function setNHD($NHD){
			$dados = new Dados();
			$this->NHD = $dados->StrToFloat($NHD);
		}
		
		public function getNHD(){
			return $this->NHD;
		}

		public function getDiasUteis(){
			return $this->diasUteis;
		}

		public function setDiasUteis($diasUteis){
			$this->diasUteis = $diasUteis;
		}
		
		public function getDiasTrab(){
			return $this->diasTrab;
		}

		public function setDiasTrab($diasTrab){
			$this->diasTrab = $diasTrab;
		}

		public function getDiasFaltantes(){
			return $this->diasFaltantes;
		}

		public function setDiasFaltantes($diasFaltantes){
			$this->diasFaltantes = $diasFaltantes;
		}

		public function getTipo(){
			return $this->tipo;
		}

		public function setTipo($tipo){
			$this->tipo = $tipo;
		}
		
		public function getMetaPor(){
			return $this->metapor;
		}

		public function setMetaPor($metapor){
			$this->metapor = $metapor;
		}

		public function getCodReferencia(){
			return $this->codReferencia;
		}

		public function setCodReferencia($codReferencia){
			$this->codReferencia = $codReferencia;
		}

		public function getCodSubgrupo(){
			return $this->codSubgrupo;
		}

		public function setCodSubgrupo($codSubgrupo){
			$this->codSubgrupo = $codSubgrupo;
		}
		
		public function getMes(){
			return $this->mes;
		}

		public function setMes($mes){
			$this->mes = $mes;
		}
		
		public function getAno(){
			return $this->ano;
		}

		public function setAno($ano){
			$this->ano = $ano;
		}
		
		public function getCodPeriodo(){
			return $this->codPeriodo;
		}

		public function setCodPeriodo($codPeriodo){
			$this->codPeriodo = $codPeriodo;
		}
		
		public function getBaseMeta(){
			return $this->baseMeta;
		}

		public function setBaseMeta($baseMeta){
			$this->baseMeta = $baseMeta;
		}
		
		public function getBaseAlcancado(){
			return $this->baseAlcancado;
		}

		public function setBaseAlcancado($baseAlcancado){
			$this->baseAlcancado = $baseAlcancado;
		}

	}
	
?>