<?php
	
	class Vendedor {
		
		private $codvendedor;
		private $nome;
		private $tipo;
		private $codsupervisor;
		private $imei;
		private $serial;
		private $visitas;
		private $visitasNegativas;
		private $nroVisitas;
		private $nroVisitasNegativas;
		private $mediaVisitas;
		private $crescVisitas;
		private $cobCliente;
		private $codgerente;		

		public function __construct() {
			$this->setCodvendedor("");
			$this->setNome("");
			$this->setTipo("");
			$this->setCodsupervisor("");
			$this->setImei("");
			$this->setSerial("");
			$this->setVisitas(array());
			$this->setVisitasNegativas(array());
			$this->setNroVisitas(0);
			$this->setNroVisitasNegativas(0);
			$this->setMediaVisitas(0);
			$this->setCrescVisitas("");
			$this->setCobCliente(0);
			$this->setCodgerente("");
		}
		
		public function getCodvendedor(){
			return $this->codvendedor;
		}

		public function setCodvendedor($codvendedor){
			$this->codvendedor = $codvendedor;
		}

		public function getNome(){
			return $this->nome;
		}

		public function setNome($nome){
			$this->nome = $nome;
		}

		public function getTipo(){
			return $this->tipo;
		}

		public function setTipo($tipo){
			$this->tipo = $tipo;
		}

		public function getCodsupervisor(){
			return $this->codsupervisor;
		}

		public function setCodsupervisor($codsupervisor){
			$this->codsupervisor = $codsupervisor;
		}

		public function getImei(){
			return $this->imei;
		}

		public function setImei($imei){
			$this->imei = $imei;
		}
		
		public function getSerial(){
			return $this->serial;
		}

		public function setSerial($serial){
			$this->serial = $serial;
		}
		
		public function getVisitas(){
			return $this->visitas;
		}

		public function setVisitas($visitas){
			$this->visitas = $visitas;
			$this->nroVisitas = 0;
			$this->cobCliente = 0;
			foreach ($this->visitas as $visita){
				$this->nroVisitas = $this->nroVisitas + $visita->getQtde();				
				if ($visita->getSituacao() === 'Positivo'){
					$this->cobCliente++;
				}
			}
		}
		
		public function setVisitasNegativas($visitasNegativas){
			$this->visitasNegativas = $visitasNegativas;
			$this->nroVisitasNegativas = 0;
			foreach ($this->visitasNegativas as $visita){
				$this->nroVisitasNegativas = $this->nroVisitasNegativas + $visita->getQtde();	
			}
		}
		
		public function getVisitasNegativas(){
			return $this->visitasNegativas;
		}

		public function getNroVisitas(){
			return $this->nroVisitas;
		}

		public function setNroVisitas($nroVisitas){
			$this->nroVisitas = $nroVisitas;
		}
		
		public function getNroVisitasNegativas(){
			return $this->nroVisitasNegativas;
		}

		public function setNroVisitasNegativas($nroVisitasNegativas){
			$this->nroVisitasNegativas = $nroVisitasNegativas;
		}

		public function getMediaVisitas(){
			return $this->mediaVisitas;
		}

		public function setMediaVisitas($mediaVisitas){
			$this->mediaVisitas = $mediaVisitas;
		}

		public function getCrescVisitas(){
			return $this->crescVisitas;
		}

		public function setCrescVisitas($crescVisitas){
			$this->crescVisitas = $crescVisitas;
		}

		public function getCobCliente(){
			return $this->cobCliente;
		}

		public function setCobCliente($cobCliente){
			$this->cobCliente = $cobCliente;
		}
		
		public function getCodgerente(){
			return $this->codgerente;
		}

		public function setCodgerente($codgerente){
			$this->codgerente = $codgerente;
		}
	}
	
?>