<?php
	$dir = $_SERVER['DOCUMENT_ROOT']."/".substr(substr($_SERVER['REQUEST_URI'], 1), 0, strpos(substr($_SERVER['REQUEST_URI'], 1), '/'))."/phone_gap";
	require_once($dir."/classes/Visita.class.php");
	require_once($dir."/classes/Dados.class.php");
	
	function cmp($a, $b){
		return strcmp($a->getCliente()->getNome(), $b->getCliente()->getNome());
	}
	
	class VisitaDAO {
		
		public function getVisitas($vendedor, $dataini, $datafin){
			$dados = new Dados();
			
			$sql = "select v.codcliente, c.nome, max(v.data) data, count(*) qtde
					from visitasrealizadas v
					join clientes c on v.codcliente = c.codcliente	
					where v.codcliente is not null
					".$dados->filtroSQL('V.CODVENDEDOR', $vendedor->getCodvendedor()).
					$dados->filtroDataSQL('V.DATA', $dataini, $datafin)." 
					group by 1, 2
					order by 2";
			
			$array = $dados->selectSQL($sql);
			
			$visitas = array();
			foreach ($array as $row){
				$novaVisita = new Visita();
				$novaVisita->getCliente()->setCodcliente($row["CODCLIENTE"]);
				$novaVisita->getCliente()->setNome($row["NOME"]);
				
				$sqlVisCliente = 	"select first 1 v.data, v.hora, v.motivo situacao
									from visitasrealizadas v
									where v.codcliente is not null
									".$dados->filtroSQL('V.CODVENDEDOR', $vendedor->getCodvendedor()).
									$dados->filtroSQL('V.CODCLIENTE', $novaVisita->getCliente()->getCodcliente()).
									$dados->filtroDataSQL('V.DATA', $dataini, $datafin)."
									order by 1 desc";
				
				$arrayVisCliente = $dados->selectSQL($sqlVisCliente);
				
				$novaVisita->setData(date('d/m/Y', strtotime($row["DATA"])));
				$novaVisita->setHora(date('H:i:s', strtotime($arrayVisCliente[0]["HORA"])));
				$novaVisita->setSituacao($arrayVisCliente[0]["SITUACAO"]);
				$novaVisita->setQtde($row["QTDE"]);
				
				$visitas[] = $novaVisita;
			}
			return $visitas;
		}
		
		public function visitasNegativas($vendedor, $dataini, $datafin){
			$dados = new Dados();
			
			$sql = "select c.codcliente, c.nome, max(v.data) data, count(*) qtde
					from visitasrealizadas v
					join clientes c on v.codcliente = c.codcliente
					where v.codjust > 0
					".$dados->filtroSQL('V.CODVENDEDOR', $vendedor->getCodvendedor()).
					$dados->filtroDataSQL('V.DATA', $dataini, $datafin)." 
					group by 1, 2
					
					order by 2";
					
			$array = $dados->selectSQL($sql);
			
			$visitas = array();
			foreach ($array as $row){
				$novaVisita = new Visita();
				$novaVisita->getCliente()->setCodcliente($row["CODCLIENTE"]);
				$novaVisita->getCliente()->setNome($row["NOME"]);
				
				$sqlVisCliente = 	"select first 1 v.data, v.hora, v.motivo situacao
									from visitasrealizadas v
									where v.codjust > 0
									".$dados->filtroSQL('V.CODVENDEDOR', $vendedor->getCodvendedor()).
									$dados->filtroSQL('V.CODCLIENTE', $novaVisita->getCliente()->getCodcliente()).
									$dados->filtroDataSQL('V.DATA', $dataini, $datafin)." 
									order by 1 desc";
				
				$arrayVisCliente = $dados->selectSQL($sqlVisCliente);
				
				$novaVisita->setData(date('d/m/Y', strtotime($row["DATA"])));
				$novaVisita->setHora(date('H:i:s', strtotime($arrayVisCliente[0]["HORA"])));
				$novaVisita->setSituacao($arrayVisCliente[0]["SITUACAO"]);
				$novaVisita->setQtde($row["QTDE"]);
				
				$visitas[] = $novaVisita;
			}
			return $visitas;
		}
		
		public function todasVisitas(&$vendedor, $dataini, $datafin){
			$vendedor->setVisitas($this->getVisitas($vendedor, $dataini, $datafin));
			$vendedor->setVisitasNegativas($this->visitasNegativas($vendedor, $dataini, $datafin));
		}
		
	}
	
?>