<?php
	$dir = $_SERVER['DOCUMENT_ROOT']."/".substr(substr($_SERVER['REQUEST_URI'], 1), 0, strpos(substr($_SERVER['REQUEST_URI'], 1), '/'))."/phone_gap";
	require_once($dir."/dados.php");
	require_once($dir."/classes/Cliente.class.php");
	require_once($dir."/dao/ClienteDAO.class.php");
	require_once($dir."/dao/ConfigDAO.class.php");
	
	$codvendedor = $_POST['codvendedor'];
	$dataini = $_POST['dataini'];
	$datafin = $_POST['datafin'];
	$modelo = $_POST['modelo'];
	$clientepor = $_POST['clientepor'];
	$agruparpor = $_POST['agruparpor'];
	
	$inicio = $_POST['inicio'];
	$qtde = $_POST['qtde'];
	
	$NotInicio = $inicio > 0;
	
	if ($NotInicio) { 
		$inicio--;
	}
	
	$configdao = new ConfigDAO();
	$multVend = $configdao->getDisponibilizar()->getClientes_mult_vends();
	
	$dados = new Dados();	
	$dataini = $dados->DatePickerToDate($dataini);
	$datafin = $dados->DatePickerToDate($datafin);
	
	switch ($agruparpor) {
		case "Vendedor":
			$codAG = "CODVENDEDOR";
			$descricaoAG = "NOME";
			$joinAG = " left join VENDEDORES AG on AG.CODVENDEDOR = V.CODVENDEDOR";
			break;
		case "Cidade":
			$codAG = "CODCIDADE";
			$descricaoAG = "CIDADE";
			$joinAG = " left join CIDADES AG on AG.CODCIDADE = CL.CODCIDADE";
			break;
		default:
			$codAG = "";
			$descricaoAG = "";
			$joinAG = "";
			break;
	}	

	$sql = "select first ".$qtde." skip ".$inicio." ".
			$dados->ifthen($agruparpor, 
				"AG.".$codAG." CODAG, AG.".$descricaoAG." DESCRICAOAG", 
				"null CODAG, null DESCRICAOAG"
			).
			", CL.CODCLIENTE, CL.NOME, CL.FANTASIA 
			from CLIENTES CL ".
			$dados->ifthen($clientepor == 'Clientes', 
				$dados->ifthen($multVend,
					"join CLI_VENDEDORES CV on CV.CODCLIENTE = CL.CODCLIENTE
					 join VENDEDORES V on V.CODVENDEDOR = CV.CODVENDEDOR "
					,
					"join VENDEDORES V on V.CODVENDEDOR = CL.CODVENDEDOR "
				)
				,
				"join ROTEIRIZACOES_CLIENTES RC on RC.CODCLIENTE = CL.CODCLIENTE 
				 join ROTEIRIZACOES RR on RR.CODROTA = RC.CODROTA 
				 join VENDEDORES V on V.CODVENDEDOR = RR.CODVENDEDOR "
			).
			"left join PEDIDOS P on P.CODCLIENTE = CL.CODCLIENTE 
								and P.CODVENDEDOR = V.CODVENDEDOR
								and P.TIPO not in ('M', 'R') and P.SITUACAO <> 4 ".
								$dados->filtroDataSQL('P.DATA', $dataini, $datafin). " ".
								$joinAG. " ".
			"where coalesce(CL.SITUACAO, '') <> 'I' 
				and P.NROPEDIDO is ". $dados->ifthen($modelo == 'Positivados', "not", "") ." null ".
				$dados->ifthen($codvendedor, " and (V.CODVENDEDOR = ".$codvendedor." or V.CODSUPERVISOR = ".$codvendedor.") ", "").
			"group by 1, 2, 3, 4, 5
			 order by 1, 2, 3, 4";

	$array = $dados->SelectSQL($sql);
	
	$qtdeRegistros = count($array);
	if ($qtdeRegistros <= 0) {
		return;
	}
	
	if ($NotInicio) {
		$agrup = $array[0]["CODAG"];
		unset($array[0]);
	} else {
		$agrup = '';
	}
	
	$clientes = array();
	foreach ($array as $row) {
		$novoCliente = new Cliente();
		$novoCliente->setCodCliente($row["CODCLIENTE"]);
		$novoCliente->setNome($row["NOME"]);
		$novoCliente->setFantasia($row["FANTASIA"]);
		$novoCliente->setCodAgrup($row["CODAG"]);
		$novoCliente->setDescAgrup($row["DESCRICAOAG"]);
		
		$sqlUltVenda = "select first 1 P.DATA from PEDIDOS P
				where P.CODCLIENTE = ".$novoCliente->getCodCliente()." and
					P.TIPO not in ('M', 'R') and
					P.SITUACAO <> 4 and
					P.DATA < '".$datafin."'
				order by P.DATA desc";							
						
		$resUltVenda = $dados->SelectSQL($sqlUltVenda);
		if (isset($resUltVenda[0])) {
			$novoCliente->setDataUltVenda($resUltVenda[0]["DATA"]);
		} else {
			$novoCliente->setDataUltVenda('');
		}
		$clientes[] = $novoCliente;
	}
	
	$result = '';
	foreach ($clientes as $cliente) {
		if ($agrup != $cliente->getCodAgrup()){
			$result .= "<tr id='agrup".$cliente->getCodAgrup()."' style='background-color:blue;'>";
			$result .= '<td></td>';
			$result .= '<td><b>'.$cliente->getDescAgrup().'</b></td>';
			$result .= '<td></td>';
			$result .= '<td></td>';
			$result .= '<td></td>';
			$result .= '</tr>';
			$agrup = $cliente->getCodAgrup();
		}
		
		$txtData = $dados->DateToText($cliente->getDataUltVenda());
		if ($txtData == '') {
			$txtData = 'Nunca Comprou';
		}
		
		$result .= '<tr>';
		$result .= '<td>'.$cliente->getCodCliente().'</td>';
		$result .= '<td>'.$cliente->getNome().'</td>';
		$result .= '<td>'.$cliente->getFantasia().'</td>';
		$result .= '<td>'.$txtData.'</td>';
		$result .= '<td>'.$cliente->getNroDiasSemVenda().'</td>';
		$result .= '</tr>';
	}
		
	if ($qtdeRegistros < $qtde) {
		$result .= "<tr style='background-color:green;font-weight: bold;' class='final-tabela'>
					<td></td><td>Total de Registros: ".($inicio + $qtdeRegistros)."</td><td></td><td></td><td></td><td></td>
					</tr>";
	}
	
	echo $result;		
?>
