<?php

  include_once('config.php');

  function ultimomanifesto ($codvendedor) {
    $codvendedor = vendedorEquipe($codvendedor);
    $query =
      "select first 1 V.NRODOCUMENTO NRODOCUMENTO from VENDAS V ".
      "where V.NRODOCUMENTO is not null ".
      "and coalesce(V.NRORECARGA, 0) <= 0 ".
      "and SUBSTRING(V.CODNATOPER FROM 1 FOR 5) IN ('5.904', '5.414', '6.904', '6.414', '5.415', '6.415') ".
      "and V.CODVENDEDOR = $codvendedor ".
      "and V.SITUACAO = 'I' ".
      "order by V.NROVENDA DESC";

    $query = ibase_query($query);
    $query = ibase_fetch_object($query);
    if ($query != null and $query->NRODOCUMENTO > 0)
      return $query->NRODOCUMENTO;
    else
      return 0;

  }

  function padraopedido($codvendedor) {
    $query =
      "select PADRAO_PEDIDO from VENDEDORES where CODVENDEDOR = ".$codvendedor;

    $query = ibase_query($query);
    $query = ibase_fetch_object($query);
    if ($query != null)
      //A prioridade  tratar o pedido como pronta entrega quanto o tipo  ambos, isso tudo para baixar corretamente do manifesto ativo
      if ($query->PADRAO_PEDIDO == "A")
        return "R";
      else
        return $query->PADRAO_PEDIDO;
    else
      return "P";


  }

  function vendedorEquipe($codvendedor) {
    $queryvend = ibase_query("select CODVENDEDOR, coalesce(CODVENDEDOR_EQUIP,0) CODVENDEDOR_EQUIP from VENDEDORES ".
          "where CODVENDEDOR = ".$codvendedor);
    $queryvend = ibase_fetch_object($queryvend);
    if ($queryvend == null)
      throw new Exception("Vendedor ".$codvendedor." no localizado");
    if ($queryvend->CODVENDEDOR_EQUIP > 0)
      return $queryvend->CODVENDEDOR_EQUIP;
    else
      return $queryvend->CODVENDEDOR;
  }


?>